(function () {
    const on_icons = {
        "16": "images/16_on.png",
        "32": "images/32_on.png",
        "48": "images/48_on.png",
        "128": "images/128_on.png"
    };
    const off_icons = {
        "16": "images/16_off.png",
        "32": "images/32_off.png",
        "48": "images/48_off.png",
        "128": "images/128_off.png"
    };

    function generateInlineButton(tabId) {
        chrome.scripting.executeScript({
            target: { tabId: tabId },
            func: () => {
                let containerId = 'bookmark-container-dj48u';
                
                // If our bookmark element already exists in the DOM, then exit this function
                if (document.getElementById(containerId)) {
                    return;
                }

                const style = document.createElement('style');
                style.textContent = `
                    #${containerId} {
                        line-height: 1;
                        margin: 0;
                        position: fixed;
                        background-color: lightblue;
                        top: 0;
                        right: 0;
                        z-index: 10000;
                        padding: 10px;
                        font-family: Arial, Helvetica, sans-serif, "Segoe UI Symbol";
                        font-size: 13px;
                        box-sizing: border-box;
                        border-radius: 0px 0px 0px 5px;
                        cursor: pointer;
                        border-left: 1px solid black;
                        border-bottom: 1px solid black;
                        user-select: none;
                        color: black;
                        text-align: center;
                    }

                    #${containerId}:hover {
                        background-color: #d8ecf3;
                        color: green;
                    }
                `;
                document.head.appendChild(style);

                let container = document.createElement('div');
                let originalContainerText = '\u00A0\u00A0\u00A0➕ Bookmark Page\u00A0\u00A0\u00A0';
                container.id = containerId;
                container.textContent = originalContainerText;
                document.body.appendChild(container);

                let containerWidth = window.getComputedStyle(container).getPropertyValue('width');
                container.style.width = containerWidth;

                // Event listener for when using clicks the button
                container.addEventListener('click', function(e) {
                    chrome.runtime.sendMessage({ action: 'bookmarkCurrentPage' });
                    e.target.textContent = '!!! Bookmark Added !!!';
                    
                    // Animate the text to indicate successful bookmark addition
                    setTimeout(() => {
                        e.target.textContent = '!! Bookmark Added !!';
                    }, 500);

                    setTimeout(() => {
                        e.target.textContent = '! Bookmark Added !';
                    }, 1000);

                    setTimeout(() => {
                        e.target.textContent = originalContainerText;
                    }, 1500);
                    
                    
                });
            }
        }).catch(error => {
            console.log('Attempting to insert inline bookmark button failed:', error);
        });
    }

    // Check whether enableInline is enabled or not and set the extension icon accordingly
    chrome.storage.local.get(['enableInline']).then(result => {
        if (result.enableInline) {
            chrome.action.setIcon({ path: on_icons });
        } else {
            chrome.action.setIcon({ path: off_icons });
        }
    });

    // Set default configuration values on install. If some values already exist, don't overwrite those
    chrome.runtime.onInstalled.addListener(() => {
        const defaults = {
            bookmarks: [],
            enableInline: true
        }

        chrome.storage.local.get(null, existingData => {
            const merged = { ...defaults, ...existingData };
            chrome.storage.local.set(merged);
            if (merged.enableInline) {
                chrome.action.setIcon({ path: on_icons });
            } else {
                chrome.action.setIcon({ path: off_icons });
            }
        });
    });

    // Event listener for when the webpage changes
    chrome.tabs.onUpdated.addListener((tabId, changeInfo, tab) => {
        if (changeInfo.status === 'complete') {
            chrome.storage.local.get(['enableInline']).then(result => {
                if (result.enableInline) {
                    // List of domains where extension cannot run
                    let restrictedDomains = [
                        'chrome://',
                        'chrome-extension://',
                        'https://chrome.google.com/webstore',
                        'https://duckduckgo.com/chrome_newtab',
                        'https://www.google.com/_/chrome/newtab',
                        'edge://',
                        'moz-extension://',
                    ];

                    // If current tab's URL starts with the restricted domains, then exit
                    for (let i = 0; i < restrictedDomains.length; i++) {
                        if (tab.url.startsWith(restrictedDomains[i])) {
                            return;
                        }
                    }

                    // If we make it this far, then the domain likely isn't restricted, generate inline button
                    generateInlineButton(tabId);    
                    
                }
            });
        }
    });

    // Service worker listener for when user clicks the inline bookmark page button
    chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
        if (message.action === 'bookmarkCurrentPage') {
            chrome.tabs.query({ active: true, currentWindow: true }, tabs => {
                let newEntry = {id: crypto.randomUUID(), title: tabs[0].title, url: tabs[0].url }
                chrome.storage.local.get(['bookmarks']).then(result => {
                    let bookmarks = result.bookmarks
                    bookmarks.push(newEntry);
                    chrome.storage.local.set({bookmarks: bookmarks});
                });
            });
        }
    });



})();